const puppeteer = require('puppeteer');
const fs = require('fs');
const ejs = require('ejs');

// Get command-line arguments passed from Java
const jsonDataPath = process.argv[2];
const templatePath = process.argv[3];
const outputImagePath = process.argv[4];
const configPath = process.argv[5];

// Read data from JSON file
const data = JSON.parse(fs.readFileSync(jsonDataPath, 'utf8'));

// Read config file for Puppeteer options
const config = JSON.parse(fs.readFileSync(configPath, 'utf8'));

// Render EJS template with data
ejs.renderFile(templatePath, data, {}, async (err, html) => {
    if (err) {
        console.error('Error rendering template:', err);
        return;
    }

    // Launch Puppeteer and generate image
    try {
        const browser = await puppeteer.launch({
            headless: config.headless !== undefined ? config.headless : true,
            args: ['--no-sandbox', '--disable-setuid-sandbox'],
        });

        const page = await browser.newPage();

        // Set viewport size (can be configured in config.json)
        await page.setViewport({
            width: config.width || 1920,
            height: config.height || 1080,
            deviceScaleFactor: config.deviceScaleFactor || 1
        });

        await page.setContent(html, { waitUntil: 'networkidle0' });

        // Take screenshot with options
        await page.screenshot({
            path: outputImagePath,
            fullPage: config.fullPage !== undefined ? config.fullPage : true,
            type: config.imageType || 'png',
            quality: config.imageType === 'jpeg' ? (config.quality || 80) : undefined,
            omitBackground: config.transparentBackground || false
        });

        await browser.close();
        console.log('Image generated at:', outputImagePath);
    } catch (error) {
        console.error('Error generating image:', error);
    }
});